#!/bin/bash

APP_NAME="MercuryLuxPc"
INSTALL_DIR="$HOME/Applications/$APP_NAME"
DESKTOP_FILE="$HOME/.local/share/applications/${APP_NAME}.desktop"

echo "Installing required system packages for xcb..."
REQUIRED_PACKAGES=(
    libxcb1
    libxcb-xinerama0
    libxcb-icccm4
    libxcb-image0
    libxcb-keysyms1
    libxcb-render-util0
    libxcb-cursor0
    libxkbcommon-x11-0
    libx11-xcb1
)

MISSING=()
for pkg in "${REQUIRED_PACKAGES[@]}"; do
    dpkg -s "$pkg" &>/dev/null || MISSING+=("$pkg")
done

if [ ${#MISSING[@]} -ne 0 ]; then
    echo "Installing missing packages: ${MISSING[*]}"
    sudo apt update && sudo apt install -y "${MISSING[@]}"
else
    echo "All required packages already installed."
fi

echo "Installing $APP_NAME to $INSTALL_DIR..."
mkdir -p "$INSTALL_DIR"
cp -r * "$INSTALL_DIR"

echo "Creating desktop entry at $DESKTOP_FILE..."
mkdir -p "$(dirname "$DESKTOP_FILE")"
cat << EOD > "$DESKTOP_FILE"
[Desktop Entry]
Type=Application
Name=Mercury Lux PC
Exec=$INSTALL_DIR/run.sh
Icon=$INSTALL_DIR/icons/MercuryLuxPc.png
Terminal=false
Categories=Utility;
EOD

chmod +x "$DESKTOP_FILE"
update-desktop-database ~/.local/share/applications/ &>/dev/null

echo "Installation complete. Launch from Main Menu > Utility > Mercury Lux PC."
